/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ddl.DDLGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLProvider;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

class DDLGeneratorTest {
    DDLGeneratorTest() {
    }

    @Test
    void addedTablesAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Table totoTable = new Table("toto");
        totoTable.addColumn("id", String.class);
        testInstance.addTables(totoTable, new Table[0]);
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR)"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto"}));
        totoTable.addColumn("name", String.class);
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR, name VARCHAR)"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto"}));
    }

    @Test
    void overriddenColumnTypeIsTakenIntoAccount() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        SqlTypeRegistry sqlTypeRegistry = new SqlTypeRegistry(typeMapping);
        DDLGenerator testInstance = new DDLGenerator(sqlTypeRegistry, DMLNameProvider::new);
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", String.class);
        testInstance.addTables(totoTable, new Table[0]);
        sqlTypeRegistry.put(idColumn, "BLOB");
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id BLOB)"}));
    }

    @Test
    void indexesAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", String.class);
        totoTable.addIndex("totoIDX", idColumn, new Column[0]);
        testInstance.addTables(totoTable, new Table[0]);
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR)", "create index totoIDX on toto(id)"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto"}));
    }

    @Test
    void uniqueConstraintsAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", String.class);
        Column lastNameColumn = totoTable.addColumn("lastName", String.class);
        totoTable.addUniqueConstraint("UK_toto", idColumn, new Column[]{lastNameColumn});
        testInstance.addTables(totoTable, new Table[0]);
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR, lastName VARCHAR)", "alter table toto add constraint UK_toto unique (id, lastName)"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto"}));
    }

    @Test
    void foreignKeysAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Table totoTable = new Table("toto");
        Column totoPKColumn = totoTable.addColumn("id", String.class);
        Table tataTable = new Table("tata");
        Column tataPKColumn = tataTable.addColumn("id", String.class);
        totoTable.addForeignKey("totoFK", totoPKColumn, tataPKColumn);
        testInstance.addTables(totoTable, new Table[]{tataTable});
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR)", "create table tata(id VARCHAR)", "alter table toto add constraint totoFK foreign key(id) references tata(id)"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto", "drop table tata"}));
    }

    @Test
    void sequencesAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Sequence totoSequence = new Sequence("toto");
        Sequence titiSequence = new Sequence("titi").withInitialValue(Integer.valueOf(4)).withBatchSize(Integer.valueOf(50));
        testInstance.addSequences(totoSequence, new Sequence[]{titiSequence});
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create sequence toto", "create sequence titi start with 4 increment by 50"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop sequence toto", "drop sequence titi"}));
    }

    @Test
    void addedDDLProvidersAreInFinalScript() {
        JavaTypeToSqlTypeMapping typeMapping = new JavaTypeToSqlTypeMapping();
        typeMapping.put(String.class, "VARCHAR");
        DDLGenerator testInstance = new DDLGenerator(new SqlTypeRegistry(typeMapping), DMLNameProvider::new);
        Table totoTable = new Table("toto");
        totoTable.addColumn("id", String.class);
        testInstance.addTables(totoTable, new Table[0]);
        testInstance.addDDLProviders(new DDLProvider(){

            public List<String> getCreationScripts() {
                return Arrays.asList((Object[])new String[]{"my wonderful first SQL creation script", "my wonderful second SQL creation script"});
            }

            public List<String> getDropScripts() {
                return Arrays.asList((Object[])new String[]{"my wonderful first SQL drop script", "my wonderful second SQL drop script"});
            }
        }, new DDLProvider[0]);
        Assertions.assertThat((List)testInstance.getCreationScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"create table toto(id VARCHAR)", "my wonderful first SQL creation script", "my wonderful second SQL creation script"}));
        Assertions.assertThat((List)testInstance.getDropScripts()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"drop table toto", "my wonderful first SQL drop script", "my wonderful second SQL drop script"}));
    }
}

